<?php
//ciptakan object dari class Tiket
$model = new Tiket();
//panggil fungsi untuk menampilkan data tiket
$data_tiket = $model->dataTiket(); 

// Mengambil sesi user yang sedang login
$sesi = $_SESSION['USERS'] ?? null; // Pastikan sesi ada, jika tidak set null

//beri session untuk hak akses halaman member
if(isset($sesi)){ // Memastikan user sudah login
?>

    <section id="breadcrumbs" class="breadcrumbs">
        <div class="container">

            <ol>
            <li><a href="index.php?hal=home">Home</a></li>
            <li>Data Bioskop</li>
            <li>Data Tiket</li>
            </ol>
            <h2>Daftar Tiket</h2>

        </div>
    </section><section class="section schedule">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-title mt-3 ">
                        <h2>DAFTAR <span class="alternate">TIKET</span></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <?php
                        // Hanya admin dan staff yang bisa menambah tiket
                        if(isset($sesi['role']) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff')){ 
                    ?>
                        <a class="btn btn-primary btn-sm" href="index.php?hal=tiket_form" role="button"
                            title="Tambah Tiket">
                            &nbsp;<i class="fa fa-plus" aria-hidden="true"> <label class="p-2">Tambah Tiket</label> </i>&nbsp;
                        </a>
                    <?php } ?>
                    <br /><br />
                    <table class="table table-primary">
                        <thead>
                            <tr class="table-dark">
                                <th scope="col">No</th>
                                <th scope="col">Harga</th>
                                <th scope="col">Stok</th>
                                <th scope="col">Nomor Kursi</th> <th scope="col">Judul Film</th> <?php
                                    // Hanya admin dan staff yang bisa melihat kolom aksi
                                    if(isset($sesi['role']) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff')){ 
                                ?>
                                <th scope="col">Aksi</th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody class="p-4">
                            <?php
                            $no = 1;
                            if (!empty($data_tiket)) { // Cek apakah ada data tiket
                                foreach($data_tiket as $row){
                            ?>
                            <tr class="table-secondary">
                                <th scope="row"><?= $no ?></th>
                                <td>Rp.<?= number_format(htmlspecialchars($row['harga']), 0, ',', '.') ?></td>
                                <td><?= htmlspecialchars($row['stok']) ?></td>
                                <td><?= htmlspecialchars($row['nomor_kursi']) ?></td>
                                <td><?= htmlspecialchars($row['judul_film']) ?></td>
                                <td>
                                    <form action="controllers/TiketController.php" method="POST">
                                        <?php
                                            // Hanya admin yang bisa mengubah atau menghapus
                                            if(isset($sesi['role']) && $sesi['role'] == 'admin'){ 
                                        ?>
                                        <a href="index.php?hal=tiket_form_update&idedit=<?= htmlspecialchars($row['id']) ?>">
                                            <button type="button" class="btn btn-warning btn-sm" title="Ubah Tiket">
                                                <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                            </button>
                                        </a>
                                        <button type="submit" class="btn btn-danger btn-sm" name="proses" value="hapus"
                                            onclick="return confirm('Anda Yakin Data Tiket ini Akan di Hapus?')" title="Hapus Tiket">
                                            <i class="fa fa-trash-o" aria-hidden="true"></i>
                                        </button>
                                        <input type="hidden" name="idx" value="<?= htmlspecialchars($row['id']) ?>">
                                        <?php } ?>
                                    </form>
                                </td>
                            </tr>
                            <?php
                                $no++;
                                }
                            } else {
                                echo '<tr><td colspan="6" class="text-center">Belum ada data tiket tersedia.</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
<?php 
}
else{
    // Jika belum login, arahkan kembali ke halaman login_form.php dengan pesan error
    echo '<script>alert("Anda Harus Login Dahulu !!!");';
    echo 'window.location.href="login_form.php";</script>';
    exit(); // Penting untuk menghentikan eksekusi script setelah redirect
}
?>