<?php
//ciptakan object dari class Studio
$model = new Studio();
//panggil fungsi untuk menampilkan data studio
$data_studio = $model->dataStudio(); 

// Mengambil sesi user yang sedang login
$sesi = $_SESSION['USERS'] ?? null; // Pastikan sesi ada, jika tidak set null

//beri session untuk hak akses halaman member
if(isset($sesi)){ // Memastikan user sudah login
?>

    <section id="breadcrumbs" class="breadcrumbs">
        <div class="container">
            <ol>
            <li><a href="index.php?hal=home">Home</a></li>
            <li>Data Bioskop</li>
            <li>Data Studio</li>
            </ol>
            <h2>Daftar Studio</h2>
        </div>
    </section><section class="section schedule">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-title mt-3 ">
                        <h2>DAFTAR <span class="alternate">Studio</span></h2>
                    </div>
                </div>
            </div>

            <div class="icontambah mb-5" style="margin-left: 50px;">
                <?php
                    // Hanya admin dan staff yang bisa menambah studio
                    if(isset($sesi['role']) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff')){ 
                ?>
                    <a class="btn btn-primary btn-sm" href="index.php?hal=studio_form" role="button"
                        title="Tambah Studio">
                        &nbsp;<i class="fa fa-plus" aria-hidden="true"> <label class="p-2">Tambah Studio</label> </i>&nbsp;
                    </a>
                <?php } ?>
            </div>
            
            <section id="testimonials" class="testimonials">
                <div class="container">
                    <div class="row">
                        <?php
                        if (!empty($data_studio)) { // Cek apakah ada data studio
                            foreach($data_studio as $row){
                        ?>
                        <div class="col-lg-6">
                            <div class="testimonial-it" style="padding-bottom: 100px; margin-top: 40px;">
                                <img src="assets/img/studio/<?= htmlspecialchars($row['foto']) ?>" class="testi" alt="<?= htmlspecialchars($row['nama']) ?>">
                                <h3>Studio : <?= htmlspecialchars($row['nama']) ?></h3>
                                <?php
                                // Hanya admin yang bisa mengubah atau menghapus
                                if(isset($sesi['role']) && $sesi['role'] == 'admin'){ 
                                ?>
                                <div class="d-flex justify-content-center mt-3">
                                    <form action="controllers/StudioController.php" method="POST">
                                        <a href="index.php?hal=studio_form_update&idedit=<?= htmlspecialchars($row['id']) ?>">
                                            <button type="button" class="btn btn-warning btn-sm" title="Ubah Studio">
                                                <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                            </button>
                                        </a>
                                        <button type="submit" class="btn btn-danger btn-sm" name="proses" value="hapus"
                                            onclick="return confirm('Anda Yakin Data Studio <?= htmlspecialchars($row['nama']) ?> Akan di Hapus?')" title="Hapus Studio">
                                            <i class="fa fa-trash-o" aria-hidden="true"></i>
                                        </button>
                                        <input type="hidden" name="idx" value="<?= htmlspecialchars($row['id']) ?>">
                                    </form>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php
                            }
                        } else {
                            echo '<div class="col-12"><div class="alert alert-info text-center mt-5">Belum ada data studio tersedia.</div></div>';
                        }
                        ?>
                    </div>
                </div>
            </section></div>
    </section>
<?php 
}
else{
    // Jika belum login, arahkan kembali ke halaman login_form.php dengan pesan error
    echo '<script>alert("Anda Harus Login Dahulu !!!");';
    echo 'window.location.href="login_form.php";</script>';
    exit(); // Penting untuk menghentikan eksekusi script setelah redirect
}
?>