<?php
// views/kontak.php
// View ini menampilkan halaman Kontak Kami.

// Pesan sukses atau error dari sesi (jika ada)
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
?>

<section id="breadcrumbs" class="breadcrumbs-section">
    <div class="container">
        <ol class="breadcrumb-list">
            <li><a href="index.php?hal=home">Home</a></li>
            <li>Kontak Kami</li>
        </ol>
        <h2 class="section-heading">Kontak Kami</h2>
    </div>
</section>

<section id="contact-main" class="contact-main-section">
    <div class="container">
        <h1 class="page-title">Hubungi Kami</h1>
        <p class="page-description">
            Kami siap membantu! Jangan ragu untuk menghubungi kami jika Anda memiliki pertanyaan, saran, atau masalah.
        </p>

        <div class="contact-content-grid">
            <div class="contact-info-card">
                <h3 class="card-title">Informasi Kontak</h3>
                <div class="info-group">
                    <i class="bi bi-geo-alt-fill info-icon"></i>
                    <p class="info-text">Bekasi, Jawa Barat, Indonesia</p>
                </div>
                <div class="info-group">
                    <i class="bi bi-envelope-fill info-icon"></i>
                    <p class="info-text">RR_tiket@gmail.com</p>
                </div>
                <div class="info-group">
                    <i class="bi bi-phone-fill info-icon"></i>
                    <p class="info-text">+62 8561 2233 456</p>
                </div>
                <div class="map-container">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3966.082531065111!2d106.9940251147699!3d-6.255936495475393!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e698c47b5c0e4c5%3A0x6b7b2b7b2b7b2b7b!2sBekasi%2C%20Jawa%20Barat!5e0!3m2!1sen!2sid!4v1678901234567!5m2!1sen!2sid"
                            width="100%" height="250" style="border:0; border-radius: 8px;" allowfullscreen="" loading="lazy"></iframe>
                </div>
            </div>

            <div class="contact-form-card">
                <h3 class="card-title">Kirim Pesan kepada Kami</h3>
                <form action="index.php?hal=kontak_submit_form" method="POST" class="modern-form">
                    <div class="form-group">
                        <label for="nama" class="form-label">Nama Anda:</label>
                        <input type="text" id="nama" name="nama" required class="form-input" placeholder="Nama lengkap Anda">
                    </div>
                    <div class="form-group">
                        <label for="email" class="form-label">Email Anda:</label>
                        <input type="email" id="email" name="email" required class="form-input" placeholder="Alamat email aktif Anda">
                    </div>
                    <div class="form-group">
                        <label for="subjek" class="form-label">Subjek:</label>
                        <input type="text" id="subjek" name="subjek" required class="form-input" placeholder="Subjek pesan Anda">
                    </div>
                    <div class="form-group">
                        <label for="pesan" class="form-label">Pesan Anda:</label>
                        <textarea id="pesan" name="pesan" rows="6" required class="form-textarea" placeholder="Tulis pesan Anda di sini..."></textarea>
                    </div>
                    <button type="submit" class="submit-button">
                        <i class="bi bi-send-fill button-icon"></i> Kirim Pesan
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<style>
    /* Global/Base Styles (Consistent across all views) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - Consistent across views */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Section Styling (Consistent across all views) */
    section {
        padding: 60px 0;
        overflow: hidden;
        background-color: #ffffff; /* Default background for sections */
        margin-bottom: 30px; /* Space between sections */
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }
    section:first-of-type { /* Breadcrumbs */
        margin-top: 20px;
    }
    section:last-of-type { /* Testimonials */
        margin-bottom: 0;
    }
    
    .container {
        max-width: 960px; /* Lebar container utama untuk blog detail, bisa disesuaikan */
        margin: 0 auto;
        padding: 0 15px;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: -15px; /* Kompensasi padding kolom */
    }
    .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
        padding: 15px; /* Spacing internal kolom */
        box-sizing: border-box;
    }
    .d-flex { display: flex; }
    .align-items-stretch { align-items: stretch; }
    .justify-content-center { justify-content: center; }
    .pt-4 { padding-top: 1.5rem; }
    .pt-lg-0 { padding-top: 0; }
    .img-fluid { max-width: 100%; height: auto; }


    /* Breadcrumbs Section (Consistent across views) */
    .breadcrumbs-section {
        background-color: #e9ecef;
        padding: 20px 0;
        border-radius: 8px;
        box-shadow: none;
    }
    .breadcrumb-list {
        display: flex;
        padding: 0;
        margin: 0 0 10px 0;
        list-style: none;
        font-size: 0.9em;
    }
    .breadcrumb-list li {
        color: #6c757d;
    }
    .breadcrumb-list li + li::before {
        content: "/";
        padding: 0 8px;
        color: #adb5bd;
    }
    .breadcrumb-list a {
        color: #007bff;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    .breadcrumb-list a:hover {
        color: #0056b3;
    }
    .breadcrumbs-section .section-heading {
        color: #343a40;
        font-size: 2em;
        font-weight: 700;
        margin: 0;
    }

    /* Contact Main Section */
    .contact-main-section {
        background-color: #f8f9fa; /* Latar belakang sedikit berbeda dari default section */
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .contact-main-section .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.5em;
        font-weight: 700;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .contact-main-section .page-title::after {
        content: '';
        width: 60px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }
    .contact-main-section .page-description {
        text-align: center;
        color: #6a737d;
        font-size: 1.05em;
        margin-bottom: 40px;
        line-height: 1.5;
    }

    .contact-content-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); /* 2 kolom di desktop, 1 di mobile */
        gap: 30px; /* Jarak antar kolom */
        justify-content: center;
    }

    .contact-info-card, .contact-form-card {
        background-color: #ffffff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        border: 1px solid #eee;
        display: flex;
        flex-direction: column;
        height: 100%; /* Agar tinggi kartu sama */
    }

    .card-title {
        font-size: 1.8em;
        color: #007bff;
        margin-top: 0;
        margin-bottom: 25px;
        font-weight: 600;
        position: relative;
        padding-bottom: 10px;
    }
    .card-title::after {
        content: '';
        width: 40px;
        height: 2px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 0;
        border-radius: 1px;
    }

    /* Contact Info Card */
    .info-group {
        display: flex;
        align-items: center;
        margin-bottom: 18px;
        font-size: 1em;
        color: #555;
    }
    .info-icon {
        font-size: 1.5em;
        color: #007bff;
        margin-right: 15px;
        flex-shrink: 0;
        width: 30px; /* Lebar tetap untuk ikon */
        text-align: center;
    }
    .info-text {
        margin: 0;
        word-wrap: break-word; /* Mencegah teks terlalu panjang meluber */
        flex-grow: 1;
    }
    .map-container {
        margin-top: auto; /* Dorong peta ke bawah */
        padding-top: 25px;
        border-top: 1px dashed #eee;
    }
    .map-container iframe {
        display: block; /* Hapus spasi bawah iframe */
    }

    /* Contact Form Card (menggunakan styling dari film_form.php) */
    .modern-form {
        display: flex;
        flex-direction: column;
        gap: 20px;
        flex-grow: 1; /* Agar form mengisi tinggi card */
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-label {
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
        font-size: 0.95em;
    }

    .form-input,
    .form-textarea,
    .form-select { /* Tambahkan .form-select untuk konsistensi */
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        font-size: 1em;
        color: #333;
        background-color: #fdfdfd;
        transition: border-color 0.2s ease, box-shadow 0.2s ease;
        box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
    }
    .form-input::placeholder,
    .form-textarea::placeholder {
        color: #bbb;
    }
    .form-input:focus,
    .form-textarea:focus,
    .form-select:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
        outline: none;
    }

    .form-textarea {
        resize: vertical;
        min-height: 120px; /* Sedikit lebih tinggi untuk pesan */
    }

    .submit-button {
        background-color: #007bff; /* Biru utama untuk tombol kirim */
        color: white;
        padding: 15px 25px;
        border: none;
        border-radius: 30px;
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease, transform 0.2s ease;
        box-shadow: 0 4px 10px rgba(0,123,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-top: auto; /* Dorong tombol ke bawah */
    }
    .submit-button:hover {
        background-color: #0056b3;
        transform: translateY(-2px);
    }
    .submit-button .button-icon {
        font-size: 1.2em;
    }

    /* Responsive Adjustments */
    @media (max-width: 992px) { /* Medium screens */
        .contact-content-grid {
            grid-template-columns: 1fr; /* Stack columns on smaller screens */
        }
        .contact-info-card, .contact-form-card {
            margin-bottom: 20px; /* Jarak antar card saat di-stack */
        }
        .contact-info-card:last-child, .contact-form-card:last-child {
            margin-bottom: 0;
        }
    }
    @media (max-width: 768px) {
        section {
            padding: 40px 0;
            margin-bottom: 20px;
        }
        .container {
            padding: 0 10px;
        }
        .contact-main-section .page-title {
            font-size: 2em;
        }
        .contact-main-section .page-description {
            font-size: 0.9em;
            margin-bottom: 30px;
        }
        .contact-info-card, .contact-form-card {
            padding: 20px;
        }
        .card-title {
            font-size: 1.5em;
            margin-bottom: 20px;
        }
        .info-group {
            font-size: 0.9em;
            margin-bottom: 15px;
        }
        .info-icon {
            font-size: 1.2em;
            margin-right: 10px;
        }
        .map-container {
            padding-top: 15px;
        }
        .form-label {
            font-size: 0.9em;
        }
        .form-input, .form-textarea, .form-select {
            padding: 10px 12px;
            font-size: 0.95em;
        }
        .submit-button {
            padding: 12px 20px;
            font-size: 1em;
        }
    }
    @media (max-width: 480px) {
        .contact-main-section .page-title {
            font-size: 1.8em;
        }
        .card-title {
            font-size: 1.3em;
        }
        .form-textarea {
            min-height: 100px;
        }
    }
</style>