<?php
// views/jadwal_form_update.php
// View ini digunakan untuk menampilkan formulir pembaruan jadwal.
// Variabel yang diharapkan:
// - $jadwal (array asosiatif data jadwal yang akan diedit)
// - $films (array film yang tersedia)
// Variabel-variabel ini disediakan oleh JadwalController->edit()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p style='color: green; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan $jadwal tidak kosong sebelum mencoba mengakses datanya
if (!isset($jadwal) || !is_array($jadwal)) {
    echo "<p style='color: red; text-align: center;'>Data jadwal tidak ditemukan untuk diedit.</p>";
    // Mungkin bisa redirect atau tampilkan pesan error yang lebih user-friendly
    // header('Location: /BIOSKOP/jadwal/index');
    // exit();
    return; // Hentikan eksekusi jika data jadwal tidak ada
}
?>

<div style="max-width: 600px; margin: 20px auto; padding: 20px; border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
    <h1 style="text-align: center; color: #333;">Edit Jadwal Tayang</h1>
    <h2 style="text-align: center; color: #555; font-size: 1.2em; margin-top: 10px;">
        Film: <?php echo htmlspecialchars($jadwal['film_judul']); ?> (Studio: <?php echo htmlspecialchars($jadwal['studio_nama']); ?>)
    </h2>
    
    <form action="/BIOSKOP/jadwal/update" method="POST" style="display: flex; flex-direction: column; gap: 15px;">
        <!-- Input tersembunyi untuk ID jadwal yang akan diperbarui -->
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($jadwal['id']); ?>">

        <div style="display: flex; flex-direction: column;">
            <label for="film_id" style="margin-bottom: 5px; font-weight: bold;">Pilih Film:</label>
            <select id="film_id" name="film_id" required 
                    style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
                <option value="">-- Pilih Film --</option>
                <?php
                if (!empty($films)) {
                    foreach ($films as $film) {
                        // Tandai film yang sedang digunakan oleh jadwal ini sebagai 'selected'
                        $selected = ($film['id'] == $jadwal['film_id']) ? 'selected' : '';
                        echo "<option value='" . htmlspecialchars($film['id']) . "' " . $selected . ">" . htmlspecialchars($film['judul']) . " (Studio: " . htmlspecialchars($film['studio_nama']) . ")</option>";
                    }
                }
                ?>
            </select>
            <small style="margin-top: 5px; color: #666;">Setiap film terikat pada satu studio.</small>
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="tanggal_tayang" style="margin-bottom: 5px; font-weight: bold;">Tanggal Tayang:</label>
            <input type="date" id="tanggal_tayang" name="tanggal_tayang" required 
                   value="<?php echo htmlspecialchars($jadwal['tanggal_tayang']); ?>"
                   min="<?php echo date('Y-m-d'); ?>" 
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="waktu_tayang" style="margin-bottom: 5px; font-weight: bold;">Waktu Tayang:</label>
            <input type="time" id="waktu_tayang" name="waktu_tayang" required 
                   value="<?php echo htmlspecialchars(substr($jadwal['waktu_tayang'], 0, 5)); ?>" 
                   step="1"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
            <small style="margin-top: 5px; color: #666;">Format: HH:MM (misal: 09:00, 15:30).</small>
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="harga_tiket" style="margin-bottom: 5px; font-weight: bold;">Harga Tiket:</label>
            <input type="number" id="harga_tiket" name="harga_tiket" required 
                   value="<?php echo htmlspecialchars($jadwal['harga_tiket']); ?>"
                   min="0" step="1000" placeholder="Contoh: 35000"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
            <small style="margin-top: 5px; color: #666;">Masukkan harga dalam Rupiah, tanpa titik atau koma.</small>
        </div>

        <button type="submit" 
                style="padding: 12px 20px; background-color: #28a745; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; transition: background-color 0.3s ease;">
            Perbarui Jadwal
        </button>
    </form>
</div>
