<?php
// views/forgot_password_reset.php

// Cek token & email valid
if (!isset($token) || !isset($email)) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>⚠️ Akses tidak sah. Link reset tidak valid atau sudah kadaluarsa.</p>";
    return;
}

// Flash message handling
$flashTypes = [
    'error_message' => ['#dc3545', '#f8d7da'],
    'success_message' => ['#28a745', '#d4edda']
];
foreach ($flashTypes as $type => [$textColor, $bgColor]) {
    if (isset($_SESSION[$type])) {
        echo "<div style='color: $textColor; background-color: $bgColor; padding: 12px 16px; border-radius: 6px; text-align: center; margin-bottom: 20px; font-weight: 600; max-width: 460px; margin-left: auto; margin-right: auto;'>" 
            . htmlspecialchars($_SESSION[$type]) . "</div>";
        unset($_SESSION[$type]);
    }
}
?>

<div style="max-width: 460px; margin: 50px auto; padding: 32px; background: #fff; border-radius: 12px; border: 1px solid #eee; box-shadow: 0 6px 20px rgba(0,0,0,0.06); font-family: 'Segoe UI', sans-serif;">
    <h2 style="text-align: center; color: #333; margin-bottom: 16px;">🔑 Reset Kata Sandi</h2>
    <p style="text-align: center; color: #555; font-size: 15px; margin-bottom: 25px;">
        Buat kata sandi baru untuk akun <strong><?= htmlspecialchars($email) ?></strong>.
    </p>
    
    <form action="index.php?hal=forgot_password_reset" method="POST" style="display: flex; flex-direction: column; gap: 20px;">
        <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
        <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>">

        <div>
            <label for="new_password" style="display: block; margin-bottom: 8px; font-weight: 600; color: #444;">Sandi Baru</label>
            <input type="password" id="new_password" name="new_password" required minlength="6"
                   placeholder="Minimal 6 karakter"
                   style="width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 6px; font-size: 15px;">
        </div>

        <div>
            <label for="confirm_password" style="display: block; margin-bottom: 8px; font-weight: 600; color: #444;">Konfirmasi Sandi</label>
            <input type="password" id="confirm_password" name="confirm_password" required minlength="6"
                   placeholder="Ulangi sandi baru"
                   style="width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 6px; font-size: 15px;">
        </div>

        <button type="submit"
                style="padding: 12px; background-color: #28a745; color: #fff; font-size: 16px; font-weight: bold; border: none; border-radius: 6px; cursor: pointer; transition: background-color 0.2s;">
            Reset Sekarang
        </button>
    </form>
</div>
