<?php
// views/film_form_update.php
// View ini digunakan untuk menampilkan formulir pembaruan film.
// Variabel yang diharapkan:
// - $film (array asosiatif data film yang akan diedit)
// - $kategoris (array kategori)
// - $studios (array studio)
// Variabel-variabel ini disediakan oleh FilmController->edit()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan $film tidak kosong sebelum mencoba mengakses datanya
if (!isset($film) || !is_array($film)) {
    echo "<p class='message error'>Data film tidak ditemukan untuk diedit.</p>";
    return; // Hentikan eksekusi jika data film tidak ada
}
?>

<div class="form-container">
    <h1 class="form-title">Edit Film: <?php echo htmlspecialchars($film['judul']); ?></h1>
    <p class="form-description">Perbarui detail film ini di bawah.</p>
    
    <form action="index.php?hal=film_update" method="POST" enctype="multipart/form-data" class="modern-form">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($film['id']); ?>">
        <input type="hidden" name="old_cover" value="<?php echo htmlspecialchars($film['cover'] ?? ''); ?>">

        <div class="form-group">
            <label for="judul" class="form-label">Judul Film:</label>
            <input type="text" id="judul" name="judul" required 
                   value="<?php echo htmlspecialchars($film['judul'] ?? ''); ?>"
                   class="form-input" placeholder="Masukkan judul film">
        </div>

        <div class="form-group">
            <label for="tanggal_rilis" class="form-label">Tanggal Rilis:</label>
            <input type="date" id="tanggal_rilis" name="tanggal_rilis" required 
                   value="<?php echo htmlspecialchars($film['tanggal_rilis'] ?? ''); ?>"
                   class="form-input">
        </div>

        <div class="form-group">
            <label for="sinopsis" class="form-label">Sinopsis:</label>
            <textarea id="sinopsis" name="sinopsis" rows="6" required 
                      class="form-textarea" placeholder="Tulis sinopsis film di sini..."><?php echo htmlspecialchars($film['sinopsis'] ?? ''); ?></textarea>
        </div>

        <div class="form-group">
            <label for="kategori_id" class="form-label">Kategori:</label>
            <select id="kategori_id" name="kategori_id" required class="form-select">
                <option value="">Pilih Kategori</option>
                <?php
                if (!empty($kategoris)) {
                    foreach ($kategoris as $kategori) {
                        $selected = ((isset($film['kategori_id']) && $kategori['id'] == $film['kategori_id']) ? 'selected' : '');
                        echo "<option value='" . htmlspecialchars($kategori['id']) . "' " . $selected . ">" . htmlspecialchars($kategori['kategori']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="studio_id" class="form-label">Studio Penayangan:</label>
            <select id="studio_id" name="studio_id" required class="form-select">
                <option value="">Pilih Studio</option>
                <?php
                if (!empty($studios)) {
                    foreach ($studios as $studio) {
                        $selected = ((isset($film['studio_id']) && $studio['id'] == $film['studio_id']) ? 'selected' : '');
                        echo "<option value='" . htmlspecialchars($studio['id']) . "' " . $selected . ">" . htmlspecialchars($studio['nama']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="cover" class="form-label">Cover Film:</label>
            <?php 
            $current_cover_path = (isset($film['cover']) && $film['cover']) ? "assets/img/film_covers/" . htmlspecialchars(basename($film['cover'])) : null;
            ?>
            <?php if ($current_cover_path && file_exists(dirname(__DIR__) . '/' . $current_cover_path)): ?>
                <div class="current-cover-preview">
                    <p>Cover Saat Ini:</p>
                    <img src="<?= $current_cover_path ?>" alt="Cover Film Saat Ini" class="preview-image">
                </div>
            <?php endif; ?>
            <input type="file" id="cover" name="cover" accept="image/*" class="form-input-file">
            <small class="file-info">Pilih file baru jika ingin mengubah cover. Ukuran file maksimal 2MB. Format: JPG, PNG, GIF. Kosongkan jika tidak diubah.</small>
        </div>

        <button type="submit" class="submit-button">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-save"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path><polyline points="17 21 17 13 7 13 7 21"></polyline><polyline points="7 3 7 8 15 8"></polyline></svg>
            Perbarui Film
        </button>
        <div class="form-actions-bottom">
            <a href="index.php?hal=film" class="back-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>
                Kembali
            </a>
        </div>
    </form>
</div>

<style>
    /* Global/Base Styles (re-confirm from previous versions) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Form Container */
    .form-container {
        max-width: 700px; /* Lebar lebih besar untuk form */
        margin: 40px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .form-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.5em;
        font-weight: 700;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .form-title::after {
        content: '';
        width: 60px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .form-description {
        text-align: center;
        color: #6a737d;
        font-size: 1.05em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Modern Form Styling */
    .modern-form {
        display: flex;
        flex-direction: column;
        gap: 20px; /* Jarak antar form group */
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-label {
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
        font-size: 0.95em;
    }

    .form-input,
    .form-textarea,
    .form-select {
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        font-size: 1em;
        color: #333;
        background-color: #fdfdfd;
        transition: border-color 0.2s ease, box-shadow 0.2s ease;
        box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
    }
    .form-input::placeholder,
    .form-textarea::placeholder {
        color: #bbb;
    }
    .form-input:focus,
    .form-textarea:focus,
    .form-select:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
        outline: none;
    }

    .form-textarea {
        resize: vertical; /* Hanya izinkan resize vertikal */
        min-height: 100px;
    }

    .form-select {
        appearance: none; /* Hapus panah default di beberapa browser */
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url('data:image/svg+xml;utf8,<svg fill="%23212529" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>');
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 1.2em;
        padding-right: 35px; /* Ruang untuk panah custom */
    }

    .form-input-file {
        padding: 12px 0; /* Padding vertikal saja untuk input file */
        border: 1px dashed #e0e0e0; /* Border putus-putus */
        border-radius: 8px;
        background-color: #f9f9f9;
        cursor: pointer;
        transition: background-color 0.2s ease, border-color 0.2s ease;
    }
    .form-input-file::-webkit-file-upload-button {
        visibility: hidden; /* Sembunyikan tombol default */
    }
    .form-input-file::before {
        content: 'Pilih File'; /* Teks custom untuk tombol */
        display: inline-block;
        background: #007bff;
        color: white;
        border: 1px solid #007bff;
        border-radius: 5px;
        padding: 8px 12px;
        outline: none;
        white-space: nowrap;
        -webkit-user-select: none;
        cursor: pointer;
        font-weight: 600;
        font-size: 0.9em;
        transition: background-color 0.2s ease;
        margin-left: 15px;
    }
    .form-input-file:hover::before {
        background-color: #0056b3;
        border-color: #0056b3;
    }
    .form-input-file:active::before {
        background-color: #004085;
    }
    .form-input-file[type="file"] { /* Adjust display of file input name */
        font-size: 0.9em; /* Make text smaller */
        color: #555;
        padding-left: 10px; /* Adjust padding to make space for custom button */
    }
    .file-info {
        font-size: 0.85em;
        color: #888;
        margin-top: 5px;
        padding-left: 5px;
    }

    /* Current Cover Preview */
    .current-cover-preview {
        margin-bottom: 15px;
        text-align: center;
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
        border: 1px dashed #e9ecef;
    }
    .current-cover-preview p {
        margin-top: 0;
        margin-bottom: 10px;
        font-weight: 600;
        color: #555;
        font-size: 0.95em;
    }
    .preview-image {
        max-width: 150px;
        height: auto;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        border: 1px solid #ddd;
    }


    /* Submit Button */
    .submit-button {
        background-color: #28a745; /* Green for submit */
        color: white;
        padding: 15px 25px;
        border: none;
        border-radius: 30px; /* Lebih bulat */
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease, transform 0.2s ease;
        box-shadow: 0 4px 10px rgba(40,167,69,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-top: 15px; /* Jarak dari input terakhir */
    }
    .submit-button:hover {
        background-color: #218838;
        transform: translateY(-2px);
    }
    .submit-button svg {
        vertical-align: middle;
    }

    /* Back Button */
    .form-actions-bottom {
        text-align: center;
        margin-top: 25px;
    }
    .back-button {
        background-color: #6c757d; /* Grey for back button */
        color: white;
        padding: 10px 20px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(108,117,125,0.2);
    }
    .back-button:hover {
        background-color: #5a6268;
        transform: translateY(-2px);
    }
    .back-button svg {
        vertical-align: middle;
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .form-container {
            margin: 20px 15px;
            padding: 20px;
        }
        .form-title {
            font-size: 2em;
        }
        .form-description {
            font-size: 0.9em;
            margin-bottom: 20px;
        }
        .form-group {
            gap: 5px; /* Kurangi jarak vertikal antar label dan input */
        }
        .form-label {
            font-size: 0.9em;
            margin-bottom: 5px;
        }
        .form-input, .form-textarea, .form-select {
            padding: 10px 12px;
            font-size: 0.95em;
        }
        .form-input-file::before {
            padding: 6px 10px;
            font-size: 0.85em;
            margin-left: 10px;
        }
        .file-info {
            font-size: 0.8em;
        }
        .submit-button, .back-button {
            padding: 12px 20px;
            font-size: 1em;
        }
    }
    @media (max-width: 480px) {
        .form-title {
            font-size: 1.8em;
        }
        .submit-button, .back-button {
            width: 100%;
            box-sizing: border-box;
        }
    }
</style>