<?php
// models/BaseModel.php

abstract class BaseModel {
    protected $conn;

    /**
     * Konstruktor untuk BaseModel.
     * Menerima objek koneksi MySQLi sebagai parameter.
     * Ini memastikan bahwa setiap model memiliki akses ke koneksi database yang sama.
     *
     * @param mysqli $conn Objek koneksi database MySQLi.
     */
    public function __construct(mysqli $conn) {
        $this->conn = $conn;
    }

    // Anda bisa menambahkan metode umum lainnya di sini jika diperlukan oleh semua model
    // Contoh:
    // public function find($id) { ... }
    // public function all() { ... }
    // public function create($data) { ... }
    // public function update($id, $data) { ... }
    // public function delete($id) { ... }
    // Untuk saat ini, kita akan biarkan metode spesifik di setiap model.
}
