<?php
// index.php - Front Controller untuk aplikasi BIOSKOP (Routing dengan ?hal=)

session_start(); // Selalu mulai sesi di awal

// Set error reporting untuk membantu debugging.
// NONAKTIFKAN ini di lingkungan produksi (production environment) untuk keamanan.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set timezone untuk konsistensi DateTime di PHP (penting untuk jadwal otomatis)
// Sesuaikan dengan zona waktu yang relevan, misalnya 'Asia/Jakarta' untuk WIB
date_default_timezone_set('Asia/Jakarta'); 

// 1. Inisialisasi Koneksi Database
// Pastikan file 'koneksi.php' berada di lokasi yang benar dan mengembalikan objek $conn.
require_once 'koneksi.php'; 
if (!isset($conn) || $conn->connect_error) {
    die("Koneksi database gagal: " . ($conn->connect_error ?? 'Tidak ada objek koneksi $conn.'));
}

// 2. Autoloader untuk kelas-kelas (Controllers dan Models)
// Autoloader ini akan secara otomatis memuat file kelas saat dibutuhkan.
spl_autoload_register(function ($class_name) {
    $paths = [
        __DIR__ . '/controllers/' . $class_name . '.php', // Path untuk Controllers
        __DIR__ . '/models/' . $class_name . '.php',     // Path untuk Models
        // Tambahkan path lain di sini jika kamu punya folder untuk kelas-kelas umum (misal: 'core/').
        // Contoh: __DIR__ . '/core/' . $class_name . '.php',
    ];

    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return; // Penting: Hentikan setelah menemukan dan memuat kelas
        }
    }
});

// 3. Ambil parameter 'hal' dari URL
// Ini adalah sistem routing sederhana kamu.
$hal = $_GET['hal'] ?? 'home'; // Default ke 'home' jika tidak ada parameter 'hal'

// 4. Inisiasi Variabel untuk Controller dan Metode
$controller_name = ''; 
$method_name = 'index'; // Metode default jika tidak disebutkan
$param = null;           // Parameter yang akan diteruskan ke metode controller

try {
    // 5. Logika Routing: Menentukan Controller dan Metode berdasarkan parameter 'hal'
    switch ($hal) {
        case 'home':
            $controller_name = 'FilmController'; 
            $method_name = 'index'; 
            // Panggil JadwalController untuk memastikan jadwal terbaru ada di homepage
            $jadwalControllerInstance = new JadwalController($conn);
            $jadwalControllerInstance->ensureSchedulesUpToDate();
            break;
        case 'about':
            $controller_name = 'AboutController';
            break;
        case 'blog':
            $controller_name = 'BlogController'; 
            break;
        case 'blog_detail':
            $controller_name = 'BlogController';
            $method_name = 'detail';
            $param = $_GET['id'] ?? null;
            break;
        case 'kontak':
            $controller_name = 'KontakController';
            break;
        case 'kontak_submit_form': 
            $controller_name = 'KontakController';
            $method_name = 'submitForm';
            break;
        
        // --- FILM Management ---
        case 'film':
            $controller_name = 'FilmController'; 
            $method_name = 'listFilms'; 
            $jadwalControllerInstance = new JadwalController($conn);
            $jadwalControllerInstance->ensureSchedulesUpToDate();
            break;
        case 'film_detail': 
            $controller_name = 'FilmController';
            $method_name = 'detail';
            $param = $_GET['id'] ?? null;
            break;
        case 'film_create': 
            $controller_name = 'FilmController';
            $method_name = 'create';
            break;
        case 'film_store': 
            $controller_name = 'FilmController';
            $method_name = 'store';
            break;
        case 'film_edit': 
            $controller_name = 'FilmController';
            $method_name = 'edit';
            $param = $_GET['id'] ?? null;
            break;
        case 'film_update': 
            $controller_name = 'FilmController';
            $method_name = 'update';
            break;
        case 'film_destroy': 
            $controller_name = 'FilmController';
            $method_name = 'destroy';
            $param = $_GET['id'] ?? null;
            break;

        // --- KATEGORI Management ---
        case 'kategori': $controller_name = 'KategoriController'; break;
        case 'kategori_create': $controller_name = 'KategoriController'; $method_name = 'create'; break;
        case 'kategori_store': $controller_name = 'KategoriController'; $method_name = 'store'; break;
        case 'kategori_edit': $controller_name = 'KategoriController'; $method_name = 'edit'; $param = $_GET['id'] ?? null; break;
        case 'kategori_update': $controller_name = 'KategoriController'; $method_name = 'update'; break;
        case 'kategori_destroy': $controller_name = 'KategoriController'; $method_name = 'destroy'; $param = $_GET['id'] ?? null; break;
        
        // --- STUDIO Management ---
        case 'studio': $controller_name = 'StudioController'; break;
        case 'studio_create': $controller_name = 'StudioController'; $method_name = 'create'; break;
        case 'studio_store': $controller_name = 'StudioController'; $method_name = 'store'; break;
        case 'studio_edit': $controller_name = 'StudioController'; $method_name = 'edit'; $param = $_GET['id'] ?? null; break;
        case 'studio_update': $controller_name = 'StudioController'; $method_name = 'update'; break;
        case 'studio_destroy': $controller_name = 'StudioController'; $method_name = 'destroy'; $param = $_GET['id'] ?? null; break;

        // --- KURSI Management ---
        case 'kursi': $controller_name = 'KursiController'; break;
        case 'kursi_create': $controller_name = 'KursiController'; $method_name = 'create'; break;
        case 'kursi_store': $controller_name = 'KursiController'; $method_name = 'store'; break;
        case 'kursi_edit': $controller_name = 'KursiController'; $method_name = 'edit'; $param = $_GET['id'] ?? null; break;
        case 'kursi_update': $controller_name = 'KursiController'; $method_name = 'update'; break;
        case 'kursi_destroy': $controller_name = 'KursiController'; $method_name = 'destroy'; $param = $_GET['id'] ?? null; break;

        // --- JADWAL Management ---
        case 'jadwal':
            $controller_name = 'JadwalController'; 
            $method_name = 'index'; 
            break;
        case 'jadwal_create': 
            $controller_name = 'JadwalController'; 
            $method_name = 'create'; 
            break;
        case 'jadwal_store': 
            $controller_name = 'JadwalController'; 
            $method_name = 'store'; 
            break;
        case 'jadwal_edit': 
            $controller_name = 'JadwalController'; 
            $method_name = 'edit'; 
            $param = $_GET['id'] ?? null; 
            break;
        case 'jadwal_update': 
            $controller_name = 'JadwalController'; 
            $method_name = 'update'; 
            break;
        case 'jadwal_destroy': 
            $controller_name = 'JadwalController'; 
            $method_name = 'destroy'; 
            $param = $_GET['id'] ?? null; 
            break;
        case 'jadwal_bulk_destroy': // Ini adalah rute baru untuk hapus massal
            $controller_name = 'JadwalController';
            $method_name = 'bulk_destroy';
            break;
        case 'jadwal_generate':
            $controller_name = 'JadwalController'; 
            $method_name = 'generateSchedules';
            break;

        // --- USER Management (termasuk pendaftaran/login) ---
        case 'login': $controller_name = 'LoginController'; break;
        case 'login_authenticate': $controller_name = 'LoginController'; $method_name = 'authenticate'; break;
        case 'logout': $controller_name = 'LoginController'; $method_name = 'logout'; break;
        case 'register_create': $controller_name = 'RegisterController'; $method_name = 'create'; break;
        case 'register_store': $controller_name = 'RegisterController'; $method_name = 'store'; break;
        case 'user': $controller_name = 'UserController'; break;
        case 'user_detail': $controller_name = 'UserController'; $method_name = 'detail'; $param = $_GET['id'] ?? null; break;
        case 'user_create': $controller_name = 'UserController'; $method_name = 'create'; break;
        case 'user_store': $controller_name = 'UserController'; $method_name = 'store'; break;
        case 'user_edit': $controller_name = 'UserController'; $method_name = 'edit'; $param = $_GET['id'] ?? null; break;
        case 'user_update': $controller_name = 'UserController'; $method_name = 'update'; break;
        case 'user_destroy': $controller_name = 'UserController'; $method_name = 'destroy'; $param = $_GET['id'] ?? null; break;

        // --- PEMESANAN Management ---
        case 'pemesanan_form': $controller_name = 'PemesananController'; $method_name = 'showForm'; $param = $_GET['jadwal_id'] ?? null; break;
        case 'pemesanan_process': $controller_name = 'PemesananController'; $method_name = 'processPemesanan'; break;
        case 'pemesanan_list': $controller_name = 'PemesananController'; $method_name = 'list'; break;
        case 'pemesanan_all': $controller_name = 'PemesananController'; $method_name = 'all'; break;
        case 'pemesanan_update_status': 
            $controller_name = 'PemesananController'; 
            $method_name = 'updateStatus'; 
            $param = ['id' => $_GET['id'] ?? null, 'status' => $_GET['status'] ?? null]; 
            break;
        case 'pemesanan_summary': 
            $controller_name = 'PemesananController';
            $method_name = 'showSummary';
            // Untuk pemesanan summary, biasanya butuh ID atau token. Asumsi param adalah array.
            // Perhatikan apakah parameter yang dibutuhkan hanya id atau ada tambahan token.
            $param = ['id' => $_GET['id'] ?? null, 'token' => $_GET['token'] ?? null]; 
            break;
        case 'pemesanan_get_detail': 
            $controller_name = 'PemesananController'; 
            $method_name = 'getDetail';
            $param = $_GET['id'] ?? null; 
            break;
        
        // --- LUPA SANDI (FORGOT PASSWORD) ---
        case 'forgot_password_request': $controller_name = 'ForgotPasswordController'; $method_name = 'requestForm'; break;
        case 'forgot_password_send_link': $controller_name = 'ForgotPasswordController'; $method_name = 'sendResetLink'; break;
        case 'forgot_password_sent': $controller_name = 'ForgotPasswordController'; $method_name = 'sentConfirmation'; break;
        case 'forgot_password_reset_form': $controller_name = 'ForgotPasswordController'; $method_name = 'resetForm'; $param = $_GET['token'] ?? null; break;
        case 'forgot_password_reset': $controller_name = 'ForgotPasswordController'; $method_name = 'resetPassword'; break;

        default:
            header("HTTP/1.1 404 Not Found"); 
            echo "<h1>404 Not Found</h1><p>Halaman yang diminta tidak ada.</p>";
            exit(); 
            break;
    }

    // 6. Eksekusi Controller dan Metode
    if ($controller_name && class_exists($controller_name)) {
        $controller_instance = new $controller_name($conn);
        
        if (method_exists($controller_instance, $method_name)) {
            // Logika pemanggilan metode dengan parameter yang benar.
            // Ini menangani berbagai skenario parameter (tanpa, satu, atau array).
            if ($method_name === 'updateStatus' && is_array($param)) { 
                 $controller_instance->$method_name($param['id'], $param['status']);
            } elseif ($method_name === 'showSummary' && is_array($param)) { // Perbaikan: method 'pemesanan_summary' menjadi 'showSummary'
                 $controller_instance->$method_name($param['id'], $param['token']);
            } elseif ($param !== null) { 
                $controller_instance->$method_name($param);
            } else { 
                $controller_instance->$method_name(); 
            }
        } else {
            header("HTTP/1.1 404 Not Found"); 
            echo "<h1>404 Not Found</h1><p>Metode '" . htmlspecialchars($method_name) . "' tidak ditemukan di controller '" . htmlspecialchars($controller_name) . "'.</p>";
        }
    } elseif ($controller_name) { 
        header("HTTP/1.1 500 Internal Server Error");
        echo "<h1>500 Internal Server Error</h1><p>Controller '" . htmlspecialchars($controller_name) . "' tidak ditemukan. Pastikan file ada dan nama kelasnya benar.</p>";
    } 

} catch (TypeError $e) {
    error_log("TypeError: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    header("HTTP/1.1 500 Internal Server Error"); 
    echo "<h1>500 Internal Server Error</h1><p>Terjadi kesalahan internal (TypeError). Silakan periksa log server untuk detail.</p>";
} catch (Exception $e) {
    error_log("Exception: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    header("HTTP/1.1 500 Internal Server Error"); 
    echo "<h1>500 Internal Server Error</h1><p>Terjadi kesalahan internal tak terduga. Silakan periksa log server untuk detail.</p>";
}

// 7. Tutup Koneksi Database
if ($conn) {
    $conn->close();
}
?>