<?php
// get_seats.php

// !!! PENTING: Aktifkan pelaporan error PHP secara penuh untuk debugging.
// !!! PASTIKAN UNTUK MENGHAPUS ATAU MENGOMENTARI BARIS INI
// !!! SAAT APLIKASI SUDAH SIAP UNTUK PRODUKSI (LIVE SERVER).
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Sertakan file koneksi database dan model-model yang dibutuhkan.
// Pastikan 'koneksi.php' menginisialisasi variabel koneksi PDO global, misalnya $dbh.
include_once 'koneksi.php';
include_once 'models/Kursi.php';
include_once 'models/Tiket.php';

// Periksa apakah semua parameter yang dibutuhkan (film_id, studio_id, tanggal, waktu) telah diterima.
if (isset($_GET['film_id']) && isset($_GET['studio_id']) && isset($_GET['tanggal']) && isset($_GET['waktu'])) {
    // Ambil dan sanitasi nilai parameter dari URL.
    $film_id = htmlspecialchars($_GET['film_id']);
    $studio_id = htmlspecialchars($_GET['studio_id']);
    $tanggal = htmlspecialchars($_GET['tanggal']);
    $waktu = htmlspecialchars($_GET['waktu']);

    // --- DEBUG LOG 1 ---
    // Log nilai studio_id yang diterima untuk verifikasi awal.
    error_log("DEBUG (get_seats.php): studio_id dari GET: " . $studio_id);

    // Inisialisasi objek model Kursi dan Tiket.
    $kursiModel = new \Kursi();
    $tiketModel = new \Tiket();

    // 1. Ambil SEMUA kursi yang ada di studio yang dipilih.
    // Pastikan metode getSeatsByStudio() di Kursi.php mengembalikan array.
    $all_kursi_in_studio = $kursiModel->getSeatsByStudio($studio_id);
    
    // --- DEBUG LOG 2 ---
    // Log hasil dari pemanggilan Kursi::getSeatsByStudio().
    // Ini krusial untuk memastikan data kursi dasar terambil.
    error_log("DEBUG (get_seats.php): Nilai \$all_kursi_in_studio setelah dipanggil: " . print_r($all_kursi_in_studio, true));
    
    // Periksa apakah $all_kursi_in_studio adalah array yang valid. Jika tidak, set ke array kosong
    // untuk menghindari error foreach jika data kosong/null.
    if (!is_array($all_kursi_in_studio)) {
        $all_kursi_in_studio = [];
        error_log("WARNING (get_seats.php): \$all_kursi_in_studio bukan array, direset menjadi kosong.");
    }

    // Siapkan array asosiatif untuk respons, menggunakan kursi_id sebagai kunci
    // untuk memudahkan penggabungan data tiket ke kursi yang sesuai.
    $response_seats_map = [];
    foreach ($all_kursi_in_studio as $kursi) {
        $response_seats_map[$kursi['id']] = [
            'id' => strval($kursi['id']),
            'nomor' => $kursi['nomor'],
            'harga_tiket' => null, // Default: belum ada harga tiket
            'tiket_id' => null,    // Default: belum ada tiket_id
            'stok' => 0            // Default: stok 0 (akan diperbarui jika ada tiket)
        ];
    }
    // --- DEBUG LOG 3 ---
    // Log $response_seats_map setelah semua kursi studio diisi (sebelum data tiket digabungkan).
    error_log("DEBUG (get_seats.php): response_seats_map setelah mengisi semua kursi: " . print_r($response_seats_map, true));

    // 2. Ambil informasi tiket yang tersedia (stok > 0) untuk film dan studio ini.
    // Metode ini mengambil data tiket dari tabel 'tiket'.
    $available_tickets_info = $tiketModel->getTicketsByFilmAndStudio($film_id, $studio_id);
    // --- DEBUG LOG 4 ---
    // Log hasil dari Tiket::getTicketsByFilmAndStudio().
    error_log("DEBUG (get_seats.php): Hasil dari Tiket::getTicketsByFilmAndStudio: " . print_r($available_tickets_info, true));

    // Gabungkan informasi tiket yang tersedia ke dalam $response_seats_map.
    // Ini akan memperbarui harga_tiket, tiket_id, dan stok untuk kursi yang memiliki tiket.
    foreach ($available_tickets_info as $ticket) {
        // Cek apakah kursi ini ada di $response_seats_map dan tiketnya punya stok > 0.
        if (isset($response_seats_map[$ticket['kursi_id']]) && $ticket['stok'] > 0) {
            $response_seats_map[$ticket['kursi_id']]['harga_tiket'] = strval($ticket['harga']);
            $response_seats_map[$ticket['kursi_id']]['tiket_id'] = strval($ticket['tiket_id']);
            $response_seats_map[$ticket['kursi_id']]['stok'] = $ticket['stok'];
        }
    }
    // --- DEBUG LOG 5 ---
    // Log $response_seats_map setelah digabungkan dengan info tiket.
    error_log("DEBUG (get_seats.php): response_seats_map setelah menggabungkan info tiket: " . print_r($response_seats_map, true));

    // 3. Ambil ID kursi yang sudah dipesan untuk jadwal tertentu.
    // Metode ini mengambil kursi_id dari tabel 'detail_pemesanan' (sesuai diskusi kita).
    $booked_kursi_ids = $tiketModel->getBookedSeatIdsForJadwal($film_id, $studio_id, $tanggal, $waktu);
    // --- DEBUG LOG 6 ---
    // Log daftar kursi yang sudah terbooking.
    error_log("DEBUG (get_seats.php): booked_kursi_ids: " . print_r($booked_kursi_ids, true));

    // Konversi $response_seats_map menjadi array terindeks numerik untuk format JSON.
    // Fungsi array_values() akan me-reset kunci array menjadi numerik berurutan (0, 1, 2...).
    $final_all_seats = array_values($response_seats_map);
    // --- DEBUG LOG 7 ---
    // Log array final sebelum di-encode ke JSON.
    error_log("DEBUG (get_seats.php): Final allSeats sebelum JSON encoding: " . print_r($final_all_seats, true));
    
    // Set header Content-Type agar browser tahu respons ini adalah JSON.
    header('Content-Type: application/json');
    // Encode data ke format JSON dan kirim sebagai respons.
    echo json_encode([
        'allSeats' => $final_all_seats,
        'bookedSeats' => $booked_kursi_ids
    ]);

} else {
    // Jika parameter yang dibutuhkan tidak lengkap, kirim respons error JSON.
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Parameter tidak lengkap.']);
}
?>