<?php
// controllers/KontakController.php

require_once dirname(__DIR__) . '/controllers/BaseController.php';

class KontakController extends BaseController {

    public function __construct(mysqli $conn) {
        parent::__construct($conn);
    }

    public function index() {
        // Di sini Anda bisa menangani logika untuk form kontak (misal: mengirim email)
        // Untuk saat ini, kita hanya akan menampilkan view kontak.
        $this->view('kontak');
    }

    // Metode untuk memproses pengiriman form kontak jika ada
    public function submitForm() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Logika untuk memproses data form kontak (misal: kirim email)
            $nama = $_POST['nama'] ?? '';
            $email = $_POST['email'] ?? '';
            $subjek = $_POST['subjek'] ?? '';
            $pesan = $_POST['pesan'] ?? '';

            // Contoh: validasi sederhana
            if (empty($nama) || empty($email) || empty($subjek) || empty($pesan)) {
                $this->setErrorMessage("Semua kolom wajib diisi.");
            } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $this->setErrorMessage("Format email tidak valid.");
            } else {
                // Lakukan sesuatu dengan data (misal: kirim email, simpan ke DB)
                // Contoh placeholder:
                // $to = "admin@yourdomain.com";
                // $headers = "From: " . $email . "\r\n" .
                //            "Reply-To: " . $email . "\r\n" .
                //            "X-Mailer: PHP/" . phpversion();
                // mail($to, "[Kontak Bioskop] " . $subjek, $pesan, $headers);
                $this->setSuccessMessage("Pesan Anda telah terkirim. Terima kasih!");
            }
            $this->redirect('kontak'); // Redirect kembali ke halaman kontak
        } else {
            $this->redirect('kontak');
        }
    }
}
