<?php
// controllers/BlogController.php

require_once __DIR__ . '/../controllers/BaseController.php';

// Tidak perlu require model-model seperti Users, Studio, Kategori, Film di sini
// karena data counts dan blog posts sekarang langsung diatur di view sebagai dummy data.
// Jika nanti kamu mengimplementasikan BlogModel dan menyimpan blog di DB,
// baru require Blog.php model di sini.

class BlogController extends BaseController {

    public function __construct(mysqli $conn) {
        parent::__construct($conn);
    }

    /**
     * Menampilkan daftar postingan blog.
     * Data blog posts dan counts diambil dari dummy data di views/blog.php.
     * Dipanggil oleh index.php?hal=blog
     */
    public function index() {
        // Karena views/blog.php sekarang menggunakan dummy data langsung di dalamnya,
        // controller ini tidak perlu mengambil data dari database atau model.
        // Cukup memuat view saja.
        $this->view('blog');
    }

    /**
     * Menampilkan detail postingan blog berdasarkan ID.
     * Konten postingan diambil dari dummy data di views/blog_detail.php berdasarkan $blog_id.
     * Dipanggil oleh index.php?hal=blog_detail&id=X
     * @param int $blog_id ID postingan blog.
     */
    public function detail($blog_id) {
        // Pastikan $blog_id valid sebelum meneruskannya ke view.
        if (empty($blog_id) || !is_numeric($blog_id)) {
            $this->setErrorMessage("ID postingan blog tidak valid.");
            $this->redirect('blog'); // Redirect kembali ke daftar blog jika ID tidak valid
            exit();
        }

        // Karena views/blog_detail.php menggunakan dummy data statis di dalamnya,
        // controller ini hanya perlu meneruskan $blog_id agar view tahu post mana yang harus ditampilkan.
        $this->view('blog_detail', ['blog_id' => $blog_id]);
    }

    // Anda bisa tambahkan metode lain seperti create(), store(), edit(), destroy()
    // jika di masa depan Anda ingin admin bisa mengelola postingan blog dan menyimpannya di DB.
}